package servercore.job;

import java.util.HashMap;

import servercore.data.Cookie;

public class SessionCheck {
	static private HashMap<String, Cookie> map = new HashMap<String, Cookie>();
	static public Cookie getCookie(String key) {
		Cookie cookie = map.get(key);
		if(cookie == null) {
			return null;
		}
		if(cookie.getExpire() < System.currentTimeMillis()) {
			map.put(key, null);
			return null;
		}
		return cookie;
	}
	static public void setCookie(String key, String value, long expireTo) {
		Cookie cookie = new Cookie();
		cookie.setKey(key);
		cookie.setValue(value);
		cookie.setExpire(System.currentTimeMillis() + expireTo * 1000);
		map.put(key, cookie);
	}
}
